#!/bin/bash

if [ $1 = "amd64" ]; then
  ARCH="x86_64"
elif [ $1 = "i386" ]; then
  ARCH="i686"
else
  echo "Unknown architecture!"
  exit 1
fi
DIR=$2
VER=$(echo $3 | cut -d"~" -f1)
SRC=http://mirror.yandex.ru/mozilla

TARGETDIR=$DIR/debian/firefox

if ! wget -c $SRC/firefox/releases/$VER/linux-$ARCH/en-US/firefox-$VER.tar.bz2 \
-O $DIR/firefox.tar.bz2; then
  echo "Could not download package"
  exit 1
fi

mkdir -p $TARGETDIR/usr/lib
tar xjvf firefox.tar.bz2 -C $TARGETDIR/usr/lib
rm $DIR/firefox.tar.bz2

cp -r $DIR/usr $TARGETDIR

mkdir -p $TARGETDIR/usr/share/pixmaps
cp $TARGETDIR/usr/lib/firefox/browser/icons/mozicon128.png $TARGETDIR/usr/share/pixmaps/firefox.png

mkdir $TARGETDIR/usr/bin
ln -sf /usr/lib/firefox/firefox $TARGETDIR/usr/bin/firefox

mkdir -p $TARGETDIR/usr/lib/firefox/defaults/pref
cp -rf $DIR/defaults/pref/* $TARGETDIR/usr/lib/firefox/defaults/pref
mkdir -p $TARGETDIR/usr/lib/firefox/browser/defaults/profile
cp -rf $DIR/defaults/profile/* $TARGETDIR/usr/lib/firefox/browser/defaults/profile
cp -ff $DIR/searchplugins/* $TARGETDIR/usr/lib/firefox/browser/searchplugins

LANGPACKS=("af,af" "ar,ar" "be,be" "bg,bg" "bn-BD,bn-bd" "ca,ca" \
"cs,cs" "da,da" "de,de" "el,el" "en-GB,en-gb" "eo,eo" "es-ES,es" \
"et,et" "eu,eu" "fa,fa" "fi,fi" "fr,fr" "fy-NL,fy" "gl,gl" "gu-IN,gu" \
"he,he" "hi-IN,hi" "hr,hr" "hu,hu" "id,id" "is,is" "it,it" "ja,ja" \
"kn,kn" "ko,ko" "lt,lt" "lv,lv" "nb-NO,nb" "nl,nl" "nn-NO,nn" "pl,pl" \
"pt-PT,pt" "pt-BR,pt-br" "ro,ro" "ru,ru" "sk,sk" "sl,sl" "sq,sq" \
"sr,sr" "sv-SE,sv" "th,th" "tr,tr" "uk,uk" "zh-CN,zh")

for LANGPACK in ${LANGPACKS[@]}; do
  SITENAME=$(echo $LANGPACK | cut -d, -f1)
  PKGNAME=$(echo $LANGPACK | cut -d, -f2)
  mkdir -p $TARGETDIR-locale-$PKGNAME/usr/lib/firefox/browser/extensions
  if ! wget -c $SRC/firefox/releases/$VER/linux-$ARCH/xpi/$SITENAME.xpi \
  -O $TARGETDIR-locale-$PKGNAME/usr/lib/firefox/browser/extensions/langpack-$SITENAME@firefox.mozilla.org.xpi; then
    echo "Could not download package"
    exit 1
  fi

if ! wget -c $SRC/firefox/releases/$VER/linux-$ARCH/$SITENAME/firefox-$VER.tar.bz2 \
-O $DIR/firefox.tar.bz2; then
  echo "Could not download package"
  exit 1
fi

tar xjvf firefox.tar.bz2 -C $TARGETDIR-locale-$PKGNAME/usr/lib firefox/dictionaries
# Some langpacks like ja have en-US dictionaries and we can't have dubbed files
if [ -d $TARGETDIR-locale-$PKGNAME/usr/lib/firefox/dictionaries ] && \
[ ! -f $TARGETDIR-locale-$PKGNAME/usr/lib/firefox/dictionaries/$SITENAME.dic ]; then
  rm -r $TARGETDIR-locale-$PKGNAME/usr/lib/firefox/dictionaries
fi
rm $DIR/firefox.tar.bz2

done
